#include <stdlib.h>
#include "SDL/SDL.h"
#include "../common/structs.h"
#include "../common/debug.h"
#include "../common/buffer.h"
#include "../common/misc.h"
#include "../misc/save_frame.h"
//#include "../../shader/noise.h"
#include <time.h>
#include <strings.h>
//#include "globals.h"
#include "../render/frameless.h"
#include "../render/frameless_subsample.h"
#include "../render/sub_sample.h"
#include "../render/deferred_renderer.h"
#include "../render/normal_renderer.h"
#include "../render/ray_generator.h"
#include "../shader/post_shaders.h"
#include "../simulation/simulation.h"

#include "../collision/pqp/PQP.h"

#include <math.h>


#include <pthread.h>
void render_thread(int engine);
pthread_mutex_t mutexor;

extern clock_t current_time;
extern int intersects_calced;
extern scene_data* main_scene;
extern   PQP_Model *b1;
extern   PQP_Model *b2;


extern double tessellation_degree;
extern double max_radius;
extern double min_radius;
extern int num_balls;
extern int num_interations;
extern double total_time;

void render_scene(int engine)
{
	clock_t start_time;
	clock_t finish_time;
	//pthread_t threado;
	struct timeval start;
	struct timeval end;
	double r[9];
	double a = 0.04;
	vector *v;
	static int dir = -1;

	current_time = clock();
	
	start_time = clock();

	//pthread_mutex_init(&mutexor, NULL);
	//pthread_create( &threado, NULL, (void*)render_thread, NULL);

	run_simulation();
	render_thread(engine);

	
	//pthread_join( threado, NULL);

	finish_time = clock();
	print_frame_info(start_time, finish_time, intersects_calced);

	intersects_calced = 0;

	
//	run_post_shaders();


	/*
	 rotation tests
	
	r[0] = cos(a);
	r[1] = -sin(a);
	r[2] = 0;
	
	r[3] = sin(a);
	r[4] = cos(a);
	r[5] = 0;
	
	r[6] = 0;
	r[7] = 0;
	r[8] = 0;
	
//	v = &main_scene->models[7]->rot;
//	v->x = v->x * r[0] + v->y * r[1] + v->z * r[2];
//	v->y = v->x * r[3] + v->y * r[4] + v->z * r[5];
//	v = &main_scene->models[7]->up;
//	v->x = v->x * r[0] + v->y * r[1] + v->z * r[2];
//	v->y = v->x * r[3] + v->y * r[4] + v->z * r[5];
//	if(dir < 1)
//		dir = pqp_test(dir);
//	main_scene->models[1]->pos.x += 0.1 * dir;
*/
}


void render_thread(int engine)
{
	switch(engine)
	{
		case 1:
			normal_render();
			break;
		case 2:
			deferred_render();
			break;
		case 3:
			generate_rays();
			break;
		case 4:
			frameless_render(0, main_scene->height);
			break;
		case 5:
			frameless_subsample_render();
			break;
		case 6:
			random_subsample_render();
			break;

		default:
			subsample_render(0, main_scene->height);
	}
}

